import { Module } from '@nestjs/common';
import { WatchersService } from './watchers.service';
import { WatchersController } from './watchers.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Watcher } from './entities/watcher.entity';
import { User } from 'src/shared/users/entities/user.entity';
import { JwtModule } from '@nestjs/jwt';

@Module({
  imports: [TypeOrmModule.forFeature([Watcher, User]),
  JwtModule.register({ 
        secret: process.env.JWT_SECRET || 'secret', 
      })
    ],
  controllers: [WatchersController],
  providers: [WatchersService],
})
export class WatchersModule {}
