import { Controller, Get, Post, Body, Patch, Param, Delete, UseGuards } from '@nestjs/common';
import { WatchersService } from './watchers.service';
import { CreateWatcherDto } from './dto/create-watcher.dto';
import { PermissionsGuard } from 'src/shared/auth/permissions.guards';
import { AuthGuard } from 'src/shared/auth/auth.guard';

@Controller('observadores')
export class WatchersController {
  constructor(private readonly watchersService: WatchersService) {}

  @UseGuards(AuthGuard, PermissionsGuard)
  @Post('/registro/:id')
  create(@Param('id') id: string, @Body() createWatcherDto: CreateWatcherDto) {
    return this.watchersService.create(+id, createWatcherDto);
  }

  @UseGuards(AuthGuard, PermissionsGuard)
  @Get(':id')
  findAllByOwner(@Param('id') id: string) {
    return this.watchersService.findAllByOwner(+id);
  }

  @UseGuards(AuthGuard, PermissionsGuard)
  @Get('/minhas-observacoes/:id')
  findAllByWatcher(@Param('id') id: string) {
    return this.watchersService.findAllByWatcher(+id);
  }

  @UseGuards(AuthGuard, PermissionsGuard)
  @Delete(':id/remove/:watcherId')
  remove(@Param('id') id: string, @Param('watcherId') watcherId: string) {
    return this.watchersService.remove(+id, +watcherId);
  }
}
