import { Module } from '@nestjs/common';
import { SubscriptionPlanService } from './subscription_plan.service';
import { SubscriptionPlanController } from './subscription_plan.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { SubscriptionPlan } from './entities/subscription_plan.entity';
import { SubscriptionPlanUser } from './entities/subscription_plan_user.entity';
import { JwtModule } from '@nestjs/jwt';
import { User } from 'src/shared/users/entities/user.entity';

@Module({
  imports: [TypeOrmModule.forFeature([SubscriptionPlan, SubscriptionPlanUser,User]),
      JwtModule.register({
        secret: process.env.JWT_SECRET || 'secret'
      })

],
  controllers: [SubscriptionPlanController],
  providers: [SubscriptionPlanService],
})
export class SubscriptionPlanModule {}
