import { Controller, Get, Post, Body, Patch, Param, Delete, UseGuards } from '@nestjs/common';
import { SubscriptionPlanService } from './subscription_plan.service';
import { CreateSubscriptionPlanDto } from './dto/create-subscription_plan.dto';
import { UpdateSubscriptionPlanDto } from './dto/update-subscription_plan.dto';
import { CreateSubscriptionPlanDtoUser } from './dto/create-subscription_plan_user.dto';
import { AuthGuard } from 'src/shared/auth/auth.guard';
import { PermissionsGuard } from '../../shared/auth/permissions.guards';
import { CurrentUser } from '../../shared/users/current.user.decorator';
import { RequiredRoles } from 'src/shared/auth/required-roles.decorator';
import { Roles } from 'src/shared/enums/enum';

@Controller('subscription-plan')
export class SubscriptionPlanController {
  constructor(
    private readonly subscriptionPlanService: SubscriptionPlanService
  ) {}

  @Post()
  @UseGuards(AuthGuard, PermissionsGuard)
  @RequiredRoles(Roles.ADMIN, Roles.ADMVISO360)
  create(@Body() createSubscriptionPlanDto: CreateSubscriptionPlanDto) {
    return this.subscriptionPlanService.create(createSubscriptionPlanDto);
  }

  @Post('add-user')
  @UseGuards(AuthGuard, PermissionsGuard)
  addUserToSubscriptionPlan(@Body() createSubscriptionPlanDtoUser: CreateSubscriptionPlanDtoUser){
    return this.subscriptionPlanService.addUserToSubscriptionPlan(createSubscriptionPlanDtoUser);
  }

  @Get('users-with-plan')
  findAllUsersWhithPlan() {
    return this.subscriptionPlanService.findAllUsersWhithPlan();
  }

  @Get(':id')
  findOneUserWhithPlan(@Param('id') id: string) {
    return this.subscriptionPlanService.findOneUserWhithPlan(+id);
  }

  @Get()
  findAll() {
    return this.subscriptionPlanService.findAll();
  }

  @Patch(':id')
  update(@Param('id') id: string, @Body() updateSubscriptionPlanDto: UpdateSubscriptionPlanDto) {
    return this.subscriptionPlanService.update(+id, updateSubscriptionPlanDto);
  }

  @Delete(':id')
  remove(@Param('id') id: string) {
    return this.subscriptionPlanService.remove(+id);
  }
}
