import { Post } from './post.entity';
import { User } from 'src/shared/users/entities/user.entity';
import {
  Column,
  Entity,
  ManyToOne,
  OneToMany,
  PrimaryGeneratedColumn,
} from 'typeorm';

@Entity('comentarios')
export class Comentario {
  @PrimaryGeneratedColumn()
  id: number;

  @Column()
  corpo: string;

  @Column()
  data: Date;

  @Column({ default: 0 })
  like: number;

  // 🔽 COMENTÁRIO PAI
  @ManyToOne(() => Comentario, (c) => c.respostas, {
    onDelete: 'CASCADE',
    nullable: true,
  })
  resposta: Comentario;

  // 🔽 RESPOSTAS DO COMENTÁRIO
  @OneToMany(() => Comentario, (c) => c.resposta)
  respostas: Comentario[];

  @ManyToOne(() => User, (user) => user.comentarios, { onDelete: 'CASCADE' })
  user: User;

  @ManyToOne(() => Post, (post) => post.comentario, { onDelete: 'CASCADE' })
  post: Post;
}
