import { Controller, Get, Post, Body, Patch, Param, Delete, UseGuards } from '@nestjs/common';
import { ModelsService } from './models.service';
import { CreateModelDto } from './dto/create-model.dto';
import { UpdateModelDto } from './dto/update-model.dto';
import { AuthGuard } from 'src/shared/auth/auth.guard';
import { Roles } from 'src/shared/enums/enum';
import { RequiredRoles } from 'src/shared/auth/required-roles.decorator';
import { RoleGuard } from 'src/shared/auth/role/role.guard';
import { ApiTags } from '@nestjs/swagger';

@ApiTags('Modelo dos Equipamentos')
@Controller('modelo')
export class ModelsController {
  constructor(private readonly modelsService: ModelsService) {}

  @Post('/registro')
  @UseGuards(AuthGuard, RoleGuard)
  @RequiredRoles(Roles.ADMVISO360, Roles.ADMIN)
  create(@Body() createModelDto: CreateModelDto) {
    return this.modelsService.create(createModelDto);
  }

  @Get()
  @UseGuards(AuthGuard)
  findAll() {
    return this.modelsService.findAll();
  }

  @Get(':id')
  @UseGuards(AuthGuard)
  findOne(@Param('id') id: string) {
    return this.modelsService.findOne(+id);
  }

  @Patch(':id')
  @UseGuards(AuthGuard, RoleGuard)
  @RequiredRoles(Roles.ADMVISO360, Roles.ADMIN)
  update(@Param('id') id: string, @Body() updateModelDto: UpdateModelDto) {
    return this.modelsService.update(+id, updateModelDto);
  }

  @Delete(':id')
  @UseGuards(AuthGuard, RoleGuard)
  @RequiredRoles(Roles.ADMVISO360, Roles.ADMIN)
  remove(@Param('id') id: string) {
    return this.modelsService.remove(+id);
  }
}
