import { Category } from "src/shared/category/entities/category.entity";
import { Equipament } from "src/visoflex360/equipaments/entities/equipament.entity";
import { Column, Entity, JoinColumn, ManyToMany, ManyToOne, OneToMany, PrimaryGeneratedColumn } from "typeorm";

@Entity()
export class Model {
    @PrimaryGeneratedColumn({ type: 'tinyint',  })
    id: number;

    @Column()
    model_name: string;

    @ManyToOne(() => Category, (category) => category.model)
    category: Category;

    @OneToMany(() => Equipament, (equipament) => equipament.model)
    equipament: Equipament[];
}
