import { Controller, Get, Post, Body, Patch, Param, Delete } from '@nestjs/common';
import { IndustrialFansService } from './industrial_fans.service';
import { CreateIndustrialFanDto } from './dto/create-industrial_fan.dto';
import { ApiTags } from '@nestjs/swagger';

@ApiTags('Ventiladores Indústriais')
@Controller('industrial-fans')
export class IndustrialFansController {
  constructor(private readonly industrialFansService: IndustrialFansService) {}

  @Post()
  create(@Body() createIndustrialFanDto: CreateIndustrialFanDto) {
    return this.industrialFansService.create(createIndustrialFanDto);
  }
}