import { Equipament } from "src/visoflex360/equipaments/entities/equipament.entity";
import { Schedules } from "src/visoflex360/equipaments/entities/schedules.entity";
import { Column, Entity, JoinColumn, OneToOne, PrimaryColumn } from "typeorm";

@Entity()
export class IndustrialFan {
    @PrimaryColumn({ type: 'smallint' })
    id: number;

    @Column({ type: 'mediumint', default: 0 })
    operation_hours: number;

    @OneToOne(() => Equipament, { onDelete: 'CASCADE'})
    @JoinColumn({ name: "id" })
    equipament: Equipament;

    @OneToOne(() => Schedules, (schedules) => schedules.industrial_fan)
    schedules: Schedules;
}
