import { Injectable, NotFoundException, ForbiddenException } from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { Group } from './entities/group.entity';
import { CreateGroupDto } from './dto/create-group.dto';
import { UpdateGroupDto } from './dto/update-group.dto';

@Injectable()
export class GroupService {
  constructor(
    @InjectRepository(Group)
    private groupRepository: Repository<Group>,
  ) {}
  async create(createGroupDto: CreateGroupDto, currentUserId: number) {
    const group = this.groupRepository.create({
      ...createGroupDto,
      user: { id: currentUserId },
    });
    await this.groupRepository.save(group);

    return { message: "Novo grupo criado com sucesso"};
  }

  async findAllByUser(currentUserId: number) {
    const group = await this.groupRepository.find({
      where: { user: { id: currentUserId } },
      relations: ['equipament'],
    });

    return (group.length === 0) ? { message: "Você ainda não possui grupos de equipamentos"} : group;
  }
  
  async findOne(id: number, currentUserId: number): Promise<Group> {
    const group = await this.groupRepository.findOne({
      where: { id, user: { id: currentUserId } },
      relations: ['equipament'],
    });

    if (!group) {
      throw new NotFoundException(`Grupo com ID "${id}" não encontrado ou não pertence a este usuário.`);
    }

    return group;
  }

  async update(id: number, updateGroupDto: UpdateGroupDto, userId: number) {
    const group = await this.findOne(id, userId);

    const updatedGroup = this.groupRepository.merge(group, updateGroupDto);
    
    await this.groupRepository.save(updatedGroup);
  
    return { message: "Grupo atualizado com sucesso" }
  }

  async remove(id: number, userId: number): Promise<{ message: string }> {
    const group = await this.findOne(id, userId);

    await this.groupRepository.remove(group);

    return { message: `Grupo "${group.group_name}" removido com sucesso.` };
  }
}