import { Controller, Get, Post, Body, Patch, Param, Delete, UseGuards, ParseIntPipe, HttpCode, HttpStatus } from '@nestjs/common';
import { GroupService } from './group.service';
import { CreateGroupDto } from './dto/create-group.dto';
import { UpdateGroupDto } from './dto/update-group.dto';
import { CurrentUser } from 'src/shared/users/current.user.decorator';
import { AuthGuard } from 'src/shared/auth/auth.guard';


@UseGuards(AuthGuard)
@Controller('grupos')
export class GroupController {
  constructor(private readonly groupsService: GroupService) {}

  @Post('/registro')
  create(@Body() createGroupDto: CreateGroupDto, @CurrentUser() currentUser: any) {
    return this.groupsService.create(createGroupDto, currentUser.id);
  }

  @Get()
  findAll(@CurrentUser() currentUser: any) {
    return this.groupsService.findAllByUser(currentUser.id);
  }

  @Get(':groupId')
  findOne(@Param('groupId') groupId: number, @CurrentUser() currentUser: any) {
    return this.groupsService.findOne(+groupId, currentUser.id);
  }

  @Patch(':groupId')
  update(@Param('groupId') groupId: string, @Body() updateGroupDto: UpdateGroupDto, @CurrentUser() currentUser: any) {
    return this.groupsService.update(+groupId, updateGroupDto, currentUser.id);
  }

  @Delete(':groupId')
  remove(@Param('groupId') groupId: string, @CurrentUser() currentUser: any) {
    return this.groupsService.remove(+groupId, currentUser.id);
  }
}