import { PartialType } from '@nestjs/mapped-types';
import { CreateFilesDto } from './create-files.dto';
import { IsArray, IsNotEmpty, IsOptional, IsString } from 'class-validator';

export class UpdatePathDto{
  @IsString()
  @IsNotEmpty()
  name: string;

  @IsArray()
  @IsOptional()
  @IsString({ each: true })
  allowedRoles: string[];
}
