import { IndustrialFan } from "src/visoflex360/industrial_fans/entities/industrial_fan.entity";
import { Column, Entity, JoinColumn, OneToOne, PrimaryColumn } from "typeorm";


// @Check()
@Entity()
export class Schedules {
    @PrimaryColumn()
    id: number;

    @OneToOne(() => IndustrialFan, (industrialFan) => industrialFan.schedules, { onDelete: 'CASCADE'})
    @JoinColumn({ name: "id", foreignKeyConstraintName: 'FK_Schedule_IndustrialFan'})
    industrial_fan: IndustrialFan;

    @Column({ type: 'varchar', length: 20, nullable: true})
    days_of_week: string;

    @Column({ type: 'time', default: "00:00"})
    on_at: string;

    @Column({ type: 'time', default: "00:00"})
    off_at: string;

    @Column({ type: 'varchar', default: "0"})
    speed: string;

    @Column({ type: 'varchar', default: "right"})
    direction: string;

    @Column({ type: 'boolean', default: false })
    remote_enable: boolean;
}
