import { Door } from "src/visoflex360/doors/entities/door.entity";
import { IndustrialFan } from "src/visoflex360/industrial_fans/entities/industrial_fan.entity";
import { Model } from "src/visoflex360/models/entities/model.entity";
import { User } from "src/shared/users/entities/user.entity";
import { Column, Entity, ManyToOne, OneToMany, OneToOne, PrimaryGeneratedColumn } from "typeorm";
import { Group } from "src/visoflex360/group/entities/group.entity";
import { group } from "console";

@Entity()
export class Equipament {
    @PrimaryGeneratedColumn({ type: 'smallint' })
    id: number;

    @Column({type: "varchar", nullable: false, default: "Novo Equipamento"})
    equipament_name: string;

    @Column({type: "varchar", nullable: false})
    internal_id: string;

    @Column({type: 'varchar', nullable: false})
    mac_address: string;

    @Column({type: "varchar", nullable: false, default: "Não definido"})
    section: string;

    @Column({ type: 'timestamp', default: () => 'CURRENT_TIMESTAMP'})
    created_at: Date;

    @Column({ type: 'timestamp', default: () => 'CURRENT_TIMESTAMP'})
    latest_maintanence: Date;

    @ManyToOne(() => User, (user) => user.equipament, { onDelete: 'SET NULL', nullable: true })    
    user: User | null;

    @ManyToOne(() => Model, (model) => model.equipament, {nullable: false})
    model: Model;

    @OneToOne(() => Door, (door) => door.equipament, { nullable: true, cascade: true})
    door: Door | null;

    @OneToOne(() => IndustrialFan, (industrial_fan) => industrial_fan.equipament, { nullable: true, cascade: true})
    fan: IndustrialFan | null;

    @ManyToOne(() => Group, (group) => group.equipament, { onDelete: 'SET NULL', nullable: true})
    group: Group | null;
}
