import { PartialType } from '@nestjs/mapped-types';
import { CreateEquipamentDto } from './create-equipament.dto';
import { IsBoolean, IsNotEmpty, IsNumber, IsOptional, IsPositive, IsString } from 'class-validator';
import { ApiProperty } from '@nestjs/swagger';

export class UpdateEquipamentDto extends PartialType(CreateEquipamentDto) {
    @ApiProperty({ description: 'Nome do equipamento', example: 'Porta do Estoque de Produtos Acabados' })
    @IsNotEmpty({ message: 'O nome do equipamento é obrigatório' })
    equipament_name: string;

    @ApiProperty({ description: 'Setor em que o equipamento encontra-se', example: 'Estoque de Produtos Acabados' })
    section: string;

    @ApiProperty({ description: 'Código de sincronização entre o usuário e o equipamento', example: '#123456'})
    sinc_code: string;
}

export class UpdateStatusDto {
    @IsNotEmpty({ message: "O MAC do equipamento é obrigatório" })
    @IsString({ message: "O MAC do equipamento deve ser uma string"})
    mac_address: string;

    isOpen?: boolean;
    
    hasAlert?: boolean;
    
    cicle?: number;

    operation_hours?: number;
}

export class UpdateSchedulesDto {
    @IsNotEmpty({message: 'Os dias da semana são obrigatórios'})
    days_of_week: string;

    @IsNotEmpty({message: 'A hora para ligar é obrigatória'})
    on_at: string;

    @IsNotEmpty({message: 'A hora para desligar é obrigatória'})
    off_at: string;

    @IsNotEmpty({message: 'A valocidade é obrigatória'})
    speed: string;

    @IsNotEmpty({message: 'A difereção da rotação é obrigatória'})
    direction: string;

    @IsBoolean({ message: "A configuração de programação remota deve seu um booleano"})
    remote_enable: boolean;
}

export class UpdateSchedulesByGroupDto {
    @IsNotEmpty({ message: 'O ID do grupo de equipamentos não pode ser vázio'})
    @IsPositive({ message: 'O ID do grupo de equipamentos deve ser um número positivo'})
    @IsNumber({}, { message: 'O ID do grupo de equipamentos deve ser um número válido'})
    groupId: number;
    
    @IsNotEmpty({message: 'Os dias da semana são obrigatórios'})
    days_of_week: string;

    @IsNotEmpty({message: 'A hora para ligar é obrigatória'})
    on_at: string;

    @IsNotEmpty({message: 'A hora para desligar é obrigatória'})
    off_at: string;

    @IsNotEmpty({message: 'A valocidade é obrigatória'})
    speed: string;

    @IsNotEmpty({message: 'A difereção da rotação é obrigatória'})
    direction: string;

    @IsBoolean({ message: "A configuração de programação remota deve seu um booleano"})
    remote_enable: boolean;
}