import { ApiProperty } from "@nestjs/swagger";
import { IsNotEmpty, IsNumber, IsString } from "class-validator";

export class CreateDoorDto {
    @ApiProperty({ description: 'ID da porta, é o mesmo do equipamento associado e é passado automaticamente.', type: Number, required: true })
    @IsNotEmpty({message: 'Algo deu errado. Contate o administrador do sistema. Erro: ID da porta não informado.'})
    @IsNumber({}, {message: 'Algo deu errado. Contate o administrador do sistema. Erro: ID da porta deve ser um número.'})
    id: number;
}