import { Injectable, NotFoundException } from '@nestjs/common';
import { CreateDoorDto } from './dto/create-door.dto';
import { UpdateDoorDto } from './dto/update-door.dto';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { Door } from './entities/door.entity';

@Injectable()
export class DoorsService {
  constructor(
    @InjectRepository(Door)
    private doorsRepository: Repository<Door>,
  ) {}
  create(createDoorDto: CreateDoorDto) {
    const door = this.doorsRepository.create(createDoorDto);
    return this.doorsRepository.save(door);
  }
}
