import { Controller, Get, Post, Body, Put, Param, Delete, Query } from '@nestjs/common';
import { DoorsService } from './doors.service';
import { CreateDoorDto } from './dto/create-door.dto';
import { UpdateDoorDto } from './dto/update-door.dto';
import { ApiTags } from '@nestjs/swagger';

@ApiTags('Portas')
@Controller('portas')
export class DoorsController {
  constructor(private readonly doorsService: DoorsService) {}
  
  @Post('/registro')
  create(@Body() createDoorDto: CreateDoorDto) {
    return this.doorsService.create(createDoorDto);
  }
}
