import { User } from "src/shared/users/entities/user.entity";
import { Column, Entity, ManyToOne, PrimaryGeneratedColumn } from "typeorm";

@Entity()
export class Contact {
    @PrimaryGeneratedColumn({ type: 'smallint',  })
    id: number;

    @Column({ type: 'varchar', nullable: false })
    contact_name: string;

    @Column({ type: 'varchar', nullable: false })
    cellphone: string;

    @Column({ type: 'varchar', nullable: false })
    position: string;

    @ManyToOne(() => User, user => user.contact, {
    onDelete: 'CASCADE'
    })
    user: User;
}
