import { IsNotEmpty, IsNumber, IsString } from "class-validator";

export class CreateContactDto {
    @IsNotEmpty({ message: 'O campo nome não pode ser vázio' })
    contact_name: string;

    @IsNotEmpty({ message: 'O campo telefone não pode ser vázio' })
    @IsNumber({}, { message: 'O campo telefone deve conter apenas números' })
    cellphone: string;

    @IsNotEmpty({ message: 'O campo cargo não pode ser vázio' })
    @IsString({ message: 'O campo cargo deve conter apenas letras' })
    position: string;
    
}
