import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  OneToMany,
  ManyToOne,
  ManyToMany,
} from 'typeorm';
import { Equipament } from '../../../visoflex360/equipaments/entities/equipament.entity';
import { Contact } from '../../../visoflex360/contacts/entities/contact.entity';
import { Roles } from '../../enums/enum';
import { Watcher } from '../../../visoflex360/watchers/entities/watcher.entity';
import { Order } from '../../../ecommerce/orders/entities/order.entity';
import { Group } from 'src/visoflex360/group/entities/group.entity';
import { group } from 'console';
import { PasswordResetToken } from './password-reset-token.entity';
import { Signature } from '../../../ecommerce/signatures/entities/signature.entity';
import { SubscriptionPlanUser } from 'src/visoflex360/subscription_plan/entities/subscription_plan_user.entity';
import { Course } from 'src/ecommerce/courses/entites/courses.entity';
import { FreteInfo } from 'src/ecommerce/frete_info/entities/frete_info.entity';
import { Creditcard } from 'src/ecommerce/creditcard/entities/creditcard.entity';
import { Post } from 'src/visoflex360/post/entities/post.entity';
import { Comentario } from 'src/visoflex360/post/entities/comentario.entity';
import { PostInteration } from 'src/visoflex360/post/entities/postInteration.entity';

@Entity()
export class User {
  @PrimaryGeneratedColumn({ type: 'smallint' })
  id: number;

  @Column({ type: 'varchar', length: 20, nullable: false })
  document: string;

  @Column({ type: 'varchar', length: 100, nullable: false })
  company_name: string;

  @Column({ type: 'varchar', length: 50, nullable: false })
  user_name: string;

  @Column({ type: 'varchar', length: 100, nullable: false, unique: true })
  email: string;

  @Column()
  password: string;

  @Column({ type: 'varchar', nullable: false, default: Roles.USER })
  roles: Roles;

  @Column({ type: 'varchar', length: 11, nullable: false })
  cellphone: string;

  @Column({ type: 'boolean', nullable: false, default: true })
  maintanance_notf: boolean;

  @Column({ type: 'boolean', nullable: false, default: true })
  alert_notf: boolean;

  @Column({ type: 'varchar', nullable: true, unique: true })
  sinc_code: string;

  @Column({ type: 'varchar', nullable: true })
  cep: string;

  @Column({ type: 'int', nullable: true })
  house_number: string;

  @Column({ type: 'boolean', nullable: false, default: false })
  is_aproved: boolean;

  @OneToMany(() => Equipament, (equipament) => equipament.user, {
    eager: true,
  })
  equipament: Equipament[];

  @OneToMany(() => Contact, (contact) => contact.user, {
    eager: true,
  })
  contact: Contact[];

  @OneToMany(() => Watcher, (watcher) => watcher.user_owner, {
    eager: true,
  }) //watcher.user_owner → o dono (quem está sendo observado).
  owned_watchers: Watcher[]; // Lista dos observadores

  @OneToMany(() => Watcher, (watcher) => watcher.user_watcher, {
    eager: true,
  }) //watcher.user_watcher → o observador.
  watching: Watcher[]; // Lista de quem o observador está observando

  @ManyToOne(() => Signature, (signature) => signature, {
    eager: true,
  })
  id_signature: Signature;

  @OneToMany(() => Order, (order) => order.user, {
    eager: true,
  })
  order: Order[];

  @Column({ type: 'varchar', nullable: true })
  asaas_customer_code: string;

  @OneToMany(() => Group, (group) => group.user, {})
  group: Group[];

  @OneToMany(
    () => PasswordResetToken,
    (passwordResetToken) => passwordResetToken.user,
    { eager: true },
  )
  passwordResetToken: PasswordResetToken[];

  @ManyToOne(() => Signature, (signature) => signature.users, {
    nullable: true,
    eager: true,
    onDelete: 'SET NULL',
  })
  signature: Signature;

  @OneToMany(
    () => SubscriptionPlanUser,
    (subscriptionPlanUser) => subscriptionPlanUser.user,
    { eager: true },
  )
  subscriptionPlanUsers: SubscriptionPlanUser[];

  @OneToMany(() => FreteInfo, (freteInfo) => freteInfo.user, {
    eager: true,
  })
  freteInfos: FreteInfo[];

  @OneToMany(() => Creditcard, (creditcard) => creditcard.user, {
    eager: true,
  })
  creditCards: Creditcard[];

  @OneToMany(() => Post, (post) => post.user)
  posts: Post[];

  @OneToMany(() => Comentario, (comentario) => comentario.user)
  comentarios: Comentario[];

  @OneToMany(() => PostInteration, (postInteration) => postInteration.user)
  postInteration: PostInteration[];
}
