import { IsNotEmpty, IsString, Length, Matches } from "class-validator";

export class SendMessageDto {
    @Matches(/^55\d{10,11}$/, { message: 'O número deve ter uma formato válido contendo o código do país, DDD e o número. \n Ex: 55199xxxxxxxx ' })
    cellphone: string;

    @IsString()
    @IsNotEmpty({ message: 'Message cannot be empty' })
    @Length(3, 160, { message: 'Message must be between 3 and 160 characters' })
    message: string;
}