import { Model } from 'src/visoflex360/models/entities/model.entity';
import { Column, Entity, JoinColumn, OneToMany, PrimaryGeneratedColumn } from "typeorm";

@Entity()
export class Category {
    @PrimaryGeneratedColumn({ type: 'smallint',  }) // Ensure the ID is smallint and unsigned
    id: number;

    @Column({ type: 'varchar', length: 15, nullable: false, unique: true})
    category_name: string;

    @OneToMany(() => Model, (model) => model.category)
    model: Model[];
}
