import { Module } from '@nestjs/common';
import { CategoryService } from './category.service';
import { CategoryController } from './category.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Category } from './entities/category.entity';
import { JwtModule } from '@nestjs/jwt';

@Module({
  imports: [TypeOrmModule.forFeature([Category]),
  JwtModule.register({ 
        secret: process.env.JWT_SECRET || 'secret', 
      //  signOptions: { expiresIn: '24h' }
      }),
    ],
  controllers: [CategoryController],
  providers: [CategoryService],
})
export class CategoryModule {}
