import { CanActivate, ExecutionContext, ForbiddenException, Injectable } from "@nestjs/common";

@Injectable()
export class PermissionsGuard implements CanActivate {
    canActivate(context: ExecutionContext): boolean {
        const request = context.switchToHttp().getRequest();
        const user = request.user;
        if (user.roles.indexOf('admin') > -1) {
            return true;
        }

        if (user.roles.indexOf('user') > -1) {
            const resourceOwnerId = request.params.id;
            if(user.id != Number(resourceOwnerId)) {
                throw new ForbiddenException('Você não tem permissão para acessar este recurso');
            }
            return true;
        } 
        return false;
    }
}