import { ApiProperty } from "@nestjs/swagger";
import { IsEmail, IsNotEmpty } from "class-validator";

export class authLoginDto {
    @ApiProperty({description: 'Um e-mail válido e cadastrado no banco de dados', example: 'exemplo@gmail.com'})
    @IsEmail({}, { message: 'O e-mail um deve ser um e-mail válido' })
    @IsNotEmpty({ message: 'O e-mail não pode ser nulo'})
    email: string

    @ApiProperty({description: 'Senha de no mínimo 6 dígitos', example: '246810'})
    @IsNotEmpty({ message: 'A senha não deve ser nula' })
    password: string
}