import { forwardRef, Inject, Injectable, NotFoundException } from '@nestjs/common';
import { JwtService } from '@nestjs/jwt';
import * as bcrypt from 'bcryptjs';
import { Roles } from 'src/shared/enums/enum';
import { UsersService } from 'src/shared/users/users.service';

@Injectable()
export class AuthService {
    constructor(
        private jwtService: JwtService,
        
        @Inject(forwardRef(() => UsersService))
        private usersService : UsersService,
    ) {}

    async validateUser(email: string, password: string) {
        const user = await this.usersService.findOneByEmail(email);

        if (user && bcrypt.compareSync(password, user.password)) {
            
            return user;
        }
        
        return null;
    }

    async login(user: { email: string; id: number; roles: Roles }) {
        const payload = { email: user.email, id: user.id, roles: user.roles};
        const userInfo = { id: user.id, role: user.roles };
        return {
            access_token:  this.jwtService.sign(payload)
        };
    }
}
