import { CanActivate, ExecutionContext, Injectable, UnauthorizedException } from '@nestjs/common';
import { JwtService } from '@nestjs/jwt';
import { Request } from 'express';

@Injectable()
export class AuthGuard implements CanActivate {
  constructor(
    private jwtService: JwtService
  ) {}
  canActivate(context: ExecutionContext): boolean {
    const request: Request = context.switchToHttp().getRequest();
    const token = request.headers.authorization?.replace('Bearer ', '');
    if (!token) {
      throw new UnauthorizedException('Token não fornecido');
    }
    try {
      const payload = this.jwtService.verify(token);
      request.user = payload;

      return true;
    } catch (error) {
   
      throw new UnauthorizedException('Token inválido', {cause: error});
    }
  }
}