import { Body, Controller, NotFoundException, Post } from '@nestjs/common';
import { AuthService } from './auth.service';
import { ApiOperation, ApiProperty, ApiResponse, ApiTags } from '@nestjs/swagger';
import { authLoginDto } from './dto/auth.dto';

@ApiTags('Autenticação')
@Controller('auth')
export class AuthController {
    constructor(private readonly authService: AuthService) {}

    @ApiOperation({ summary: 'Faz login na aplicação', description: 'Verifica se o e-mail ou senha estão cadastrados no banco de dados'  })
    @ApiResponse({ status: 200, description: 'Autentica o usuário e retorna o token JWT' })
    @ApiResponse({ status: 404, description: 'Registro de usuário não encontrado',
        schema: {
            type: 'object',
            properties: {
                message: { type: 'string', example: 'E-mail válido' },
                error: { type: 'string', example: 'Não encontrado' },
                statusCode: { type: 'number', example: 404 }
            },
        },
     })
    @Post('login')
    async login(@Body() body: authLoginDto) {
        if (!body.email || !body.password) {
            return { message: 'Informe e-mail e senha para efetuar o login' };
        }
        const user = await this.authService.validateUser(body.email, body.password);
        if (user) {
            return this.authService.login(user);
        }
        throw new NotFoundException('Usuário ou senha inválidos');
    }
}
