import { Module } from '@nestjs/common';

import {  ClassesController } from './classes.controller';
import { ClassesService } from './classes.service';

import { TypeOrmModule } from '@nestjs/typeorm';
import { Class } from './entities/class.entity';
import { JwtModule } from '@nestjs/jwt';


@Module({
  imports: [TypeOrmModule.forFeature([Class]),
    JwtModule.register({ 
          secret: process.env.JWT_SECRET || 'secret', 
        }),
    ],
  controllers: [ClassesController],
  providers: [ClassesService],
  exports: [ClassesService]
})
export class ClassModule {}
