import { User } from "src/shared/users/entities/user.entity";
import { Column, DeleteDateColumn, Entity, OneToMany, PrimaryGeneratedColumn, ManyToOne } from "typeorm";

@Entity()
export class Signature {
    @PrimaryGeneratedColumn()
    id: number;

    @Column({ type: 'varchar'})
    signature: string;

    @Column({ type: 'varchar'})
    imageUrl: string;

    @OneToMany(() => User, (user) => user.signature, {
        cascade: true,
        eager: false, // só carrega se for pedido explicitamente
      })
    users: User[];
}
