import { Module } from '@nestjs/common';
import { ShoppingCartService } from './shopping_cart.service';
import { ShoppingCartController } from './shopping_cart.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Order } from '../orders/entities/order.entity';
import { UsersModule } from 'src/shared/users/users.module';
import { OrderTransactions } from '../orders/entities/order_transaction.entity';
import { JwtModule } from '@nestjs/jwt';
import { ProductsModule } from '../products/products.module';
import { OrderProduct } from '../orders/entities/order_product.entity';
import { Cupom } from '../cupom/entities/cupom.entity';

@Module({
  imports: [
    UsersModule, ProductsModule,
    TypeOrmModule.forFeature([Order, OrderTransactions, OrderProduct, Cupom]),
    JwtModule.register({
      secret: process.env.JWT_SECRET || 'secret'
    })
  ],
  controllers: [ShoppingCartController],
  providers: [ShoppingCartService],
  exports: [ShoppingCartService]
})
export class ShoppingCartModule {}
