import { Controller, Get, Post, Body, Patch, Param, Delete, UseGuards } from '@nestjs/common';
import { ShoppingCartService } from './shopping_cart.service';
import { AddItemFromCartDto } from './dto/add-item-from-cart-.dto';
import { RemoveItemFromCartDto, UpdateShoppingCartDto } from './dto/update-shopping_cart.dto';
import { AuthGuard } from 'src/shared/auth/auth.guard';
import { CurrentUser } from 'src/shared/users/current.user.decorator';

@Controller('carrinho')
export class ShoppingCartController {
  constructor(private readonly shoppingCartService: ShoppingCartService) {}

  @Post('/registro')
  @UseGuards(AuthGuard)
  addItemFromCart(@CurrentUser() currentUser: any, @Body() addItemFromCart: AddItemFromCartDto) {
    return this.shoppingCartService.addItemFromCart(currentUser, addItemFromCart);
  }

  @Get('/me')
  @UseGuards(AuthGuard)
  getCartContents(@CurrentUser() currentUser: any) {
    return this.shoppingCartService.getCartContents(currentUser);
  }

  @Get('/total-itens')
  @UseGuards(AuthGuard)
  countTotalItemsInOpenOrder(@CurrentUser() currentUser: any) {
    return this.shoppingCartService.countTotalItemsInOpenOrder(currentUser);
  }
  
  @Patch('/')
  @UseGuards(AuthGuard)
  updateItemQuantityInCart(@CurrentUser() currentUser: any, @Body() updateItemFromCart: UpdateShoppingCartDto) {
    return this.shoppingCartService.updateItemQuantityInCart(currentUser, updateItemFromCart);
  }


  @Delete('/')
  @UseGuards(AuthGuard)
  removeItemFromCart(@CurrentUser() currentUser: any, @Body() removeItemFromCart: RemoveItemFromCartDto) {
    return this.shoppingCartService.removeItemFromCart(currentUser, removeItemFromCart);
  }
}

