import { OrderProduct } from "src/ecommerce/orders/entities/order_product.entity";
import { Column, DeleteDateColumn, Entity, OneToMany, PrimaryGeneratedColumn } from "typeorm";

@Entity()
export class Product {
    @PrimaryGeneratedColumn()
    id: number;

    @Column({ type: 'varchar'})
    cod_product: string;

    @Column({ type: 'varchar'})
    name: string;

    @Column({ type: 'varchar'})
    description: string;

    @Column({ type: 'float'})
    price: number;

    @Column({ type: 'varchar'})
    image: string;

    @Column({ type: 'varchar'})
    line: string;

    @Column({ type: 'varchar'})
    category: string;

    @Column()
    quantity: number;

    @Column({ default: 20})
    safety_stock: number;
    
    @Column()
    time_to_replacement: number;

    @DeleteDateColumn()
    deleted_at: Date;

    @OneToMany(() => OrderProduct, (orderProduct) => orderProduct.product, { onDelete: 'CASCADE'})
    order_product: OrderProduct;
}
