import { PaymentMethod, Status } from "src/shared/enums/enum";
import { OrderProduct } from "src/ecommerce/orders/entities/order_product.entity";
import { OrderTransactions } from "./order_transaction.entity";
import { User } from "src/shared/users/entities/user.entity";
import { Column, Entity, JoinColumn, ManyToOne, OneToMany, PrimaryGeneratedColumn, UpdateDateColumn } from "typeorm";
import { Cupom } from "src/ecommerce/cupom/entities/cupom.entity";
import { on } from "events";

@Entity()
export class Order {
    @PrimaryGeneratedColumn()
    id: number;

    @ManyToOne(() => Cupom, (cupom) => cupom.orders, { nullable: true, onDelete: 'SET NULL' })
    @JoinColumn({ name: 'cupom_id' })
    cupom: Cupom;


    @ManyToOne(() => User, user => user.order, { onDelete: 'SET NULL', nullable: true})
    user: User;    

    @OneToMany(() => OrderTransactions, (orderTransactions) => orderTransactions.order)
    order_transaction: OrderTransactions[];

    @OneToMany(() => OrderProduct, (orderProduct) => orderProduct.order)
    order_product: OrderProduct[];

    @Column({ type: 'enum', enum: Status, default: Status.OPEN})
    status: Status;

    @Column({ type: 'integer', nullable: true})
    total_items: number;

    @Column({ type: 'float', nullable: true})
    total_amount: number;

    @Column({ type: 'enum', enum: PaymentMethod})
    payment_method: PaymentMethod;

    @Column({ type: 'boolean', default: false})
    descont: boolean;

    @Column()
    paymentId: string;

    @UpdateDateColumn()
    updated_at: Date;

    @Column({ type: 'timestamp', default: () => 'CURRENT_TIMESTAMP' })
    created_at: Date;

}   
