import { IsEnum, IsNotEmpty, IsOptional, IsString } from 'class-validator';

export enum PaymentMethod {
  ONLINE_PIX = 'ONLINE_PIX',
  DEBIT_CARD = 'DEBIT_CARD',
  CREDIT_CARD = 'CREDIT_CARD',
}

export class CheckoutDto {
  @IsEnum(PaymentMethod)
  @IsNotEmpty()
  paymentMethod: PaymentMethod;

  @IsOptional()
  @IsString()
  credit_card_number: string;
}