import { BadRequestException, Injectable } from '@nestjs/common';
import { CreateFreteInfoDto } from './dto/create-frete_info.dto';
import { UpdateFreteInfoDto } from './dto/update-frete_info.dto';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { FreteInfo } from './entities/frete_info.entity';
import { User } from 'src/shared/users/entities/user.entity';

@Injectable()
export class FreteInfoService {
  constructor(
    @InjectRepository(FreteInfo)
    private freteInfoRepository: Repository<FreteInfo>,
    @InjectRepository(User)
    private userRepository: Repository<User>,
  ) {}



  async create(createFreteInfoDto: CreateFreteInfoDto, currentUser: any) {
    const existingFreteInfo = await this.freteInfoRepository.findOne({
      where: { user: { id: currentUser.id } },
    });

    if (existingFreteInfo) {
      this.freteInfoRepository.merge(existingFreteInfo, createFreteInfoDto);
      await this.freteInfoRepository.save(existingFreteInfo);
      return 'Endereço atualizado com sucesso!';
    } else {
      const freteInfo = this.freteInfoRepository.create({
        ...createFreteInfoDto,
        user: { id: currentUser.id },
      });
      await this.freteInfoRepository.save(freteInfo);
      return 'Endereço cadastrado com sucesso!';
    }
  }

  async findOne(currentUser: any) {
    if (!currentUser || !currentUser.id) {
      throw new BadRequestException('Usuário não autenticado ou inválido.');
    }
    const userExist = await this.freteInfoRepository.findOne({
      where:{user: {id: currentUser.id}}
    })
    if(!userExist){
      throw new BadRequestException('Endereço não encontrado')
    }
    return userExist;
  }

  update(CurrentUser: any, id: number, updateFreteInfoDto: UpdateFreteInfoDto) {
    const userExist = this.freteInfoRepository.findOne({
      where:{user: {id: CurrentUser.id}}
    })
    if(!userExist){
      throw new BadRequestException('Endereço não encontrado')
    }
    const update = this.freteInfoRepository.update(id, updateFreteInfoDto)
    return update;
  }

}
