import { Module } from '@nestjs/common';
import { FreteInfoService } from './frete_info.service';
import { FreteInfoController } from './frete_info.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { FreteInfo } from './entities/frete_info.entity';
import { User } from 'src/shared/users/entities/user.entity';
import { JwtModule } from '@nestjs/jwt';

@Module({
  imports: [
    TypeOrmModule.forFeature([FreteInfo, User]),
    JwtModule.register({
      secret: process.env.JWT_SECRET || 'secret',
    }),
  ],
  controllers: [FreteInfoController],
  providers: [FreteInfoService],
})
export class FreteInfoModule {}
