import { Controller, Get, Post, Body, Patch, Param, Delete, UseGuards } from '@nestjs/common';
import { FreteInfoService } from './frete_info.service';
import { CreateFreteInfoDto } from './dto/create-frete_info.dto';
import { UpdateFreteInfoDto } from './dto/update-frete_info.dto';
import { CurrentUser } from 'src/shared/users/current.user.decorator';
import { AuthGuard } from 'src/shared/auth/auth.guard';


@Controller('frete-info')
export class FreteInfoController {
  constructor(private readonly freteInfoService: FreteInfoService) {}

  @Post()
  @UseGuards(AuthGuard)
  create(@Body() createFreteInfoDto: CreateFreteInfoDto, @CurrentUser() currentUser: any){
    return this.freteInfoService.create(createFreteInfoDto, currentUser);
  }

  @Get('/my-address')
  @UseGuards(AuthGuard)
  findOne(@CurrentUser() currentUser: any) {
    return this.freteInfoService.findOne(currentUser);
  }

  @Patch(':id')
  update(@Param('id') id: string, @Body() updateFreteInfoDto: UpdateFreteInfoDto, @CurrentUser() currentUser: any){
    return this.freteInfoService.update(currentUser,+id, updateFreteInfoDto);
  }


}
