import { Module } from '@nestjs/common';
import { CupomService } from './cupom.service';
import { CupomController } from './cupom.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Cupom } from './entities/cupom.entity';
import { Order } from '../orders/entities/order.entity';
import { User } from 'src/shared/users/entities/user.entity';
import { OrderProduct } from '../orders/entities/order_product.entity';

@Module({
  imports: [
    TypeOrmModule.forFeature([Cupom, Order, User, OrderProduct])
  ],
  controllers: [CupomController],
  providers: [CupomService],
})
export class CupomModule {}
