import { User } from 'src/shared/users/entities/user.entity';
import { Column, Entity, ManyToOne, PrimaryGeneratedColumn } from 'typeorm';

@Entity()
export class Creditcard {
  @PrimaryGeneratedColumn()
  id: number;

  @Column()
  credit_card_holder_name: string;

  @Column()
  credit_card_number: string;

  @Column({ length: 4 })
  last_four_digits: string;

  @Column()
  credit_card_expiry_month: string;

  @Column()
  credit_card_expiry_year: string;

  @Column()
  ccv: string;

  @ManyToOne(() => User, (user) => user.creditCards, {
    onDelete: 'CASCADE',
  })
  user: User;
}
