import { Module } from '@nestjs/common';
import { CreditcardService } from './creditcard.service';
import { CreditcardController } from './creditcard.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Creditcard } from './entities/creditcard.entity';
import { User } from 'src/shared/users/entities/user.entity';
import { JwtModule } from '@nestjs/jwt';

@Module({
  imports: [
    TypeOrmModule.forFeature([Creditcard, User]),
    JwtModule.register({
      secret: process.env.JWT_SECRET || 'secret',
    }),
  ],
  controllers: [CreditcardController],
  providers: [CreditcardService],
})
export class CreditcardModule {}
