import { Controller, Get, Post, Body, Patch, Param, Delete, UseGuards } from '@nestjs/common';
import { CreditcardService } from './creditcard.service';
import { CreateCreditcardDto } from './dto/create-creditcard.dto';
import { UpdateCreditcardDto } from './dto/update-creditcard.dto';
import { AuthGuard } from 'src/shared/auth/auth.guard';
import { CurrentUser } from 'src/shared/users/current.user.decorator';

@Controller('creditcard')
export class CreditcardController {
  constructor(private readonly creditcardService: CreditcardService) {}

  @Post()
  @UseGuards(AuthGuard)
  create(@Body() createCreditcardDto: CreateCreditcardDto, @CurrentUser() currentUser: any) {
    return this.creditcardService.create(createCreditcardDto, currentUser);
  }

  @Get()
  @UseGuards(AuthGuard)
  findAll(@CurrentUser() currentUser: any) {
    return this.creditcardService.findAll(currentUser);
  }

  @Get('last')
  @UseGuards(AuthGuard)
  finfindLastCardRegisterdOne(@CurrentUser() currentUser: any) {
    return this.creditcardService.findLastCardRegister(currentUser);
  }

  @Patch(':id')
  update(@Param('id') id: string, @Body() updateCreditcardDto: UpdateCreditcardDto) {
    return this.creditcardService.update(+id, updateCreditcardDto);
  }

  @Delete(':id')
  remove(@Param('id') id: string) {
    return this.creditcardService.remove(+id);
  }
}
