import { Entity, PrimaryGeneratedColumn, Column, OneToMany, JoinTable, ManyToMany } from 'typeorm';
// Certifique-se que o caminho do import está correto
import { Class } from '../../videos/entities/class.entity'; 
import { User } from 'src/shared/users/entities/user.entity';
import { Course_payment } from 'src/ecommerce/course_payment/entities/course_payment.entity';

@Entity()
export class Course {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ type: 'varchar' })
  title: string;

  @Column({ type: 'varchar' })
  description: string;

  @Column({ type: 'varchar', nullable: true })
  category: string;

  @Column({ type: 'varchar', nullable: true })
  status: string;

  @Column({ type: 'varchar', nullable: true })
  thumbnail: string;

  @Column({ type: 'varchar', nullable: true })
  level: string;

  @Column({ type: 'int', nullable: true })
  price: number;

  @Column('simple-array', { nullable: true })
  urls: string[];

  

  
  @ManyToMany(() => Class, (classEntity) => classEntity.courses, {onDelete: 'CASCADE'})
  @JoinTable()
  classes: Class[];

  @OneToMany(() => Course_payment, payment => payment.course, { onDelete: 'CASCADE'})
  payments: Course_payment[];
}
