import { IsNotEmpty, IsNumber, IsOptional, IsPositive, IsString, IsArray } from "class-validator";
// REMOVIDO: import { Column } from "typeorm"; (Não deve ser usado em DTOs)

export class CreateCourseDto {

  // CONFIGURAÇÃO PERFEITA PARA O MANY-TO-MANY
  @IsNotEmpty()
  @IsArray()
  @IsNumber({}, { each: true }) // Valida se cada item dentro do array é um número
  classIds: number[];

  @IsNotEmpty()
  @IsString()
  title: string;

  @IsNotEmpty()
  @IsString()
  description: string;

  // Se na Entity é nullable, aqui recomenda-se IsOptional
  @IsOptional() 
  @IsString()
  category?: string;

  @IsOptional()
  @IsString()
  status?: string;

  @IsOptional()
  @IsString()
  level?: string;

  @IsOptional() // Adicione se o preço puder ser nulo/zero inicialmente
  @IsNumber()
  @IsPositive()
  price?: number;

  @IsString()
  @IsOptional()
  thumbnail?: string;
}