import { Module } from '@nestjs/common';



import { TypeOrmModule } from '@nestjs/typeorm';
import { JwtModule } from '@nestjs/jwt';
import { CourseController } from './courses.controller';
import { CourseService } from './courses.service';
import { Course } from './entites/courses.entity';
import { Class } from '../videos/entities/class.entity';
import { User } from 'src/shared/users/entities/user.entity';
import { Course_payment } from '../course_payment/entities/course_payment.entity';
import { CourseLessonProgress } from './entites/course_lesson_progress.entity';



@Module({
  imports: [TypeOrmModule.forFeature([Course, Class, User,Course_payment,CourseLessonProgress]),
    JwtModule.register({ 
          secret: process.env.JWT_SECRET || 'secret', 
        }),
    ],
  controllers: [CourseController],
  providers: [CourseService],
  exports: [CourseService]
})
export class CourseModule {}
