import { Module } from "@nestjs/common";
import { Course_paymentController } from "./course_payment.controller";
import { Course_paymentService } from "./course_payment.service";
import { Course_payment } from "./entities/course_payment.entity";
import { TypeOrmModule } from "@nestjs/typeorm";
import { JwtModule } from "@nestjs/jwt";
import { AsaasModule } from "../asaas/asaas.module";
import { UsersModule } from "src/shared/users/users.module";
import { CourseModule } from "../courses/courses.module";

import { AsaasGateway } from "../asaas/asaas.gateway";
import { AsaasService } from "../asaas/asaas.service";
import { Creditcard } from "../creditcard/entities/creditcard.entity";

@Module({
    imports: [
        TypeOrmModule.forFeature([Course_payment, Creditcard]),
        JwtModule.register({ 
            secret: process.env.JWT_SECRET || 'secret', 
        }),
        AsaasModule,
        UsersModule,
        CourseModule
    ],
    controllers: [Course_paymentController],
    providers: [Course_paymentService],
    exports: [Course_paymentService]

})
export class Course_paymentModule {}