import { Body, Controller, Get, Param, Post, UseGuards } from "@nestjs/common";
import { Course_paymentService } from "./course_payment.service";
import { CreateCourse_paymentDto } from "./dto/create-course_payment.dto";
import { CurrentUser } from "src/shared/users/current.user.decorator";
import { AuthGuard } from "src/shared/auth/auth.guard";
import { RoleGuard } from "src/shared/auth/role/role.guard";
import { AsaasService } from "../asaas/asaas.service";

@Controller('course_payment')
export class Course_paymentController {
  constructor(private readonly course_paymentService: Course_paymentService,
    private readonly asaasService: AsaasService,
  ) {}

  @Post('/:id')
  @UseGuards(AuthGuard)
  create(@CurrentUser() currentUser: any, @Param('id') id: number, @Body() createChargeDto: CreateCourse_paymentDto){
    return this.course_paymentService.create(currentUser.id, id, createChargeDto);
  }

  @Get(':paymentId')
  @UseGuards(AuthGuard)
  async confirmPayment(@Param('paymentId') paymentId: string) {
    return await this.course_paymentService.confirmPayment(paymentId);
  }


  @Get()
  @UseGuards(AuthGuard)
  getQrCode(@CurrentUser() currentUser: any) {
    return this.course_paymentService.getQrCode(currentUser.id);
  }

  
}