import { forwardRef, Module } from '@nestjs/common';
import { HttpModule } from '@nestjs/axios';
import { AsaasService } from './asaas.service';
import { AsaasController } from './asaas.controller';
import { AsaasGateway } from './asaas.gateway';
import { TypeOrmModule } from '@nestjs/typeorm';
import { User } from 'src/shared/users/entities/user.entity';
import { Order } from 'src/ecommerce/orders/entities/order.entity';
import { Course_payment } from 'src/ecommerce/course_payment/entities/course_payment.entity'
import { OrdersModule } from '../orders/orders.module';
import { JwtModule } from '@nestjs/jwt';
import { Creditcard } from '../creditcard/entities/creditcard.entity';

@Module({
  imports: [HttpModule, forwardRef(() => OrdersModule),
    TypeOrmModule.forFeature([User, Order, Course_payment, Creditcard]),
    JwtModule.register({
      secret: process.env.JWT_SECRET || 'secret'
    })
  ],
  providers: [AsaasService, AsaasGateway],
  controllers: [AsaasController],
  exports: [AsaasService],
})
export class AsaasModule {}
