import { Controller, Post, Body, Headers, HttpCode, Get, UseGuards, Param, Patch, HttpException, HttpStatus, UnauthorizedException} from '@nestjs/common';
import { AsaasService } from './asaas.service';
import { RoleGuard } from 'src/shared/auth/role/role.guard';
import { Roles } from 'src/shared/enums/enum';
import { CurrentUser } from 'src/shared/users/current.user.decorator';
import { AuthGuard } from 'src/shared/auth/auth.guard';

@Controller('asaas')
export class AsaasController {
  constructor(
    private readonly asaasService: AsaasService,
  ) {}
   @Post()
   @HttpCode(200)
   handleWebHook(@Body() body: any, @Headers() headers: any) {
     console.log('Webhook recebido. Body:', body);
     // Retornar a promise garante que o NestJS aguardará a conclusão
     return this.asaasService.handlePaymentWebhook(body);
   }

  @Get(':paymentId/qrcode')
  @UseGuards(AuthGuard)
  getPixQrCode(@Param('paymentId') paymentId: string) {
    return this.asaasService.getPixQrCode(paymentId)
  }

   @Get('subscriptions/:userId')
  async getUserSubscriptions(@Param('userId') userId: string) {
    try {
      const subscriptions = await this.asaasService.getUserSubscriptions(userId);
      return {
        success: true,
        total: subscriptions.length,
        data: subscriptions,
      };
    } catch (error) {
      console.error('Erro no controller:', error.message);
      throw new HttpException(
        {
          success: false,
          message: 'Erro ao buscar assinaturas do usuário',
          details: error.response?.data || error.message,
        },
        HttpStatus.BAD_REQUEST,
      );
    }
  }

  @Patch(':orderId/simular-pagamento')
  @UseGuards(AuthGuard)
  fakePayment(@Param('orderId') orderId: string, @CurrentUser() currentUser: any) {
    return this.asaasService.fakePayment(currentUser.id, +orderId);
  }

  @Post('/Teste')
  @UseGuards(AuthGuard)
  createSubscription(@CurrentUser() currentUser: any) {
    return this.asaasService.createSubscription(currentUser.id);
  }

  @Post('/assinar')
  @UseGuards(AuthGuard)
  paySubscription(@CurrentUser() currentUser: any) {
    return this.asaasService.paySubscription(+currentUser.id);
  }
}
